/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.render;

import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.light.data.SingleBlockLightDataCache;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.render.AbstractBlockRenderContext;
import net.caffeinemc.mods.sodium.client.render.frapi.render.QuadEncoder;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteFinderCache;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.render.BlockVertexConsumerProvider;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_324;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_6575;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class NonTerrainBlockRenderContext
extends AbstractBlockRenderContext {
    public static final ThreadLocal<NonTerrainBlockRenderContext> POOL = ThreadLocal.withInitial(NonTerrainBlockRenderContext::new);
    private class_324 colorMap;
    private final SingleBlockLightDataCache lightDataCache = new SingleBlockLightDataCache();
    private BlockVertexConsumerProvider vertexConsumer;
    private Matrix4f matPosition;
    private boolean trustedNormals;
    private Matrix3f matNormal;
    private int overlay;

    public NonTerrainBlockRenderContext() {
        this.lighters = new LightPipelineProvider(this.lightDataCache);
        this.random = new class_6575(42L);
    }

    public void renderModel(class_1920 blockView, class_324 blockColors, class_1087 model, class_2680 state, class_2338 pos, class_4587 poseStack, BlockVertexConsumerProvider buffer, boolean cull, long seed, int overlay) {
        this.level = blockView;
        this.state = state;
        this.pos = pos;
        this.colorMap = blockColors;
        this.vertexConsumer = buffer;
        this.matPosition = poseStack.method_23760().method_23761();
        this.trustedNormals = poseStack.method_23760().field_48930;
        this.matNormal = poseStack.method_23760().method_23762();
        this.overlay = overlay;
        this.defaultRenderType = class_4696.method_23679((class_2680)state);
        this.lightDataCache.reset(pos, blockView);
        this.prepareCulling(cull);
        this.random.method_43052(seed);
        ((FabricBlockStateModel)model).emitQuads(this.getEmitter(), blockView, pos, state, this.random, this::isFaceCulled);
        this.defaultRenderType = null;
        this.level = null;
        this.lightDataCache.release();
        this.vertexConsumer = null;
    }

    @Override
    protected void processQuad(MutableQuadViewImpl quad) {
        TriState aoMode = quad.ambientOcclusion();
        ShadeMode shadeMode = quad.shadeMode();
        LightMode lightMode = aoMode == TriState.DEFAULT ? this.defaultLightMode : (this.useAmbientOcclusion && aoMode.get() ? LightMode.SMOOTH : LightMode.FLAT);
        boolean emissive = quad.emissive();
        class_4588 vertexConsumer = this.getVertexConsumer(quad.renderLayer());
        this.tintQuad(quad);
        this.shadeQuad(quad, lightMode, emissive, shadeMode);
        this.bufferQuad(quad, vertexConsumer);
    }

    private class_4588 getVertexConsumer(class_11515 blendMode) {
        return this.vertexConsumer.getBuffer(blendMode == null ? this.defaultRenderType : blendMode);
    }

    private class_1921 toRenderLayer(class_11515 defaultRenderType) {
        return switch (defaultRenderType) {
            default -> throw new MatchException(null, null);
            case class_11515.field_60923 -> class_1921.method_23577();
            case class_11515.field_60924 -> class_1921.method_23579();
            case class_11515.field_60925 -> class_1921.method_23581();
            case class_11515.field_60926 -> class_1921.method_29380();
            case class_11515.field_60927 -> class_1921.method_29997();
        };
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        if (quad.tintIndex() != -1) {
            int blockColor = 0xFF000000 | this.colorMap.method_1697(this.state, this.level, this.pos, quad.tintIndex());
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorMixer.mulComponentWise(blockColor, quad.color(i)));
            }
        }
    }

    @Override
    protected void shadeQuad(MutableQuadViewImpl quad, LightMode lightMode, boolean emissive, ShadeMode shadeMode) {
        super.shadeQuad(quad, lightMode, emissive, shadeMode);
        float[] brightnesses = this.quadLightData.br;
        for (int i = 0; i < 4; ++i) {
            quad.color(i, ColorARGB.mulRGB(quad.color(i), brightnesses[i]));
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, class_4588 vertexConsumer) {
        QuadEncoder.writeQuadVertices(quad, vertexConsumer, this.overlay, this.matPosition, this.trustedNormals, this.matNormal);
        class_1058 sprite = quad.sprite(SpriteFinderCache.forBlockAtlas());
        if (sprite != null) {
            SpriteUtil.INSTANCE.markSpriteActive(sprite);
        }
    }
}

