/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.class_1703;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class RecipeSortUtil {
    private static final Comparator<RecipeLayoutWithButtons<?>> CRAFTABLE_COMPARATOR = RecipeSortUtil.createCraftableComparator();

    public static List<IRecipeCategory<?>> sortRecipeCategories(List<IRecipeCategory<?>> recipeCategories, IRecipeTransferManager recipeTransferManager) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return recipeCategories;
        }
        class_1703 openContainer = player.field_7512;
        if (openContainer == null) {
            return recipeCategories;
        }
        Comparator<IRecipeCategory> comparator = Comparator.comparing(r -> {
            Optional recipeTransferHandler = recipeTransferManager.getRecipeTransferHandler(openContainer, r);
            return recipeTransferHandler.isPresent();
        }).reversed();
        return recipeCategories.stream().sorted(comparator).toList();
    }

    public static Comparator<RecipeLayoutWithButtons<?>> getCraftableComparator() {
        return CRAFTABLE_COMPARATOR;
    }

    private static Comparator<RecipeLayoutWithButtons<?>> createCraftableComparator() {
        return Comparator.comparingInt(r -> {
            IRecipeLayoutDrawable recipeLayout = r.recipeLayout();
            RecipeTransferButton transferButton = r.transferButton();
            int missingCount = transferButton.getMissingCountHint();
            if (missingCount == -1) {
                return 0;
            }
            IRecipeSlotsView recipeSlotsView = recipeLayout.getRecipeSlotsView();
            int ingredientCount = RecipeSortUtil.ingredientCount(recipeSlotsView);
            if (ingredientCount == 0) {
                return 0;
            }
            int matchCount = ingredientCount - missingCount;
            int matchPercent = 100 * matchCount / ingredientCount;
            return -matchPercent;
        });
    }

    private static int ingredientCount(IRecipeSlotsView recipeSlotsView) {
        int count = 0;
        for (IRecipeSlotView i : recipeSlotsView.getSlotViews()) {
            if (i.getRole() != RecipeIngredientRole.INPUT || i.isEmpty()) continue;
            ++count;
        }
        return count;
    }
}

